# Mnemo

**Intelligent Tab Management Through Automated Context Capture**

Mnemo is a privacy-focused Chrome extension that intelligently manages your browser tabs by automatically archiving inactive tabs while preserving their complete context for instant restoration.

## Features

### Smart Tab Archiving
- **Automatic archiving** based on tab inactivity and importance scores
- **ML-powered personalization** that learns your browsing patterns
- **Custom domain rules** for fine-grained control over archiving behavior
- **Duplicate tab detection** to automatically close redundant tabs

### Powerful Search
- **TF-IDF search engine** for relevance-based results
- **Full-text search** across titles, URLs, and page content
- **Screenshot previews** of archived tabs
- **Timeline view** to browse your browsing history

### Privacy First
- **100% local storage** - all data stays on your device
- **No tracking or analytics**
- **Optional screenshot capture**
- **Clear data management** with granular control

### ML Features
- **Pattern learning** to identify important tabs
- **Smart startup** that auto-restores routine tabs
- **Personalization scores** to protect frequently used domains
- **Context-aware suggestions** based on browsing behavior

## Installation

1. Clone this repository or download the source code
2. Open Chrome and navigate to `chrome://extensions/`
3. Enable "Developer mode" in the top right
4. Click "Load unpacked" and select the Mnemo directory
5. The Mnemo icon will appear in your extensions toolbar

## Usage

### Basic Usage
- Click the Mnemo icon to open the side panel
- **Vault tab**: View and restore archived tabs
- **Timeline tab**: Browse your browsing history
- **Settings tab**: Customize archiving behavior

### Keyboard Shortcuts
- `Alt+A` - Archive current tab
- `Alt+V` - Open Mnemo vault
- `Alt+R` - Restore last archived tab

### Archiving Settings
- **Archive Threshold**: Score threshold for auto-archiving (lower = more aggressive)
- **Max Active Tabs**: Maximum number of tabs before archiving kicks in
- **Minimum Inactive Time**: How long tabs must be inactive before archiving
- **Auto-close duplicates**: Automatically close duplicate tabs

### Domain Rules
Create custom rules for specific domains:
- **Never Archive**: Prevent certain domains from being archived
- **Custom Threshold**: Set domain-specific archiving thresholds
- **Custom Inactive Time**: Override inactive time for specific domains

## Privacy

Mnemo is designed with privacy as a core principle:

- All data is stored locally using IndexedDB
- No data is ever sent to external servers
- No tracking, analytics, or telemetry
- Screenshots are optional and stored locally
- Clear data options available in settings

For full privacy details, see [PRIVACY.md](PRIVACY.md)

## Technology Stack

- **Frontend**: Vanilla JavaScript, HTML, CSS
- **Storage**: IndexedDB via Chrome Storage API
- **Search**: Custom TF-IDF implementation
- **ML**: Pattern detection and learning algorithms
- **APIs**: Chrome Extensions Manifest V3

## Data Storage

Mnemo uses IndexedDB for efficient local storage:
- **Vault entries**: Archived tabs with full context
- **Search index**: TF-IDF indices for fast search
- **ML patterns**: Learned browsing patterns
- **Settings**: User preferences and domain rules

## Development

### File Structure
```
Mnemo/
├── manifest.json          # Extension manifest
├── background/           # Background scripts
│   ├── service-worker.js # Main background service
│   ├── archiver.js       # Auto-archiving logic
│   ├── scoring.js        # Tab scoring system
│   ├── patterns.js       # ML pattern detection
│   ├── search.js         # TF-IDF search engine
│   ├── storage.js        # IndexedDB wrapper
│   └── resurfacing.js    # Context suggestions
├── sidepanel/           # Side panel UI
│   ├── index.html       # Main UI
│   ├── app.js          # UI logic
│   └── styles.css      # Styles
├── content/            # Content scripts
│   └── capture.js      # Page content capture
└── assets/            # Icons and assets
```

### Building

No build step required - Mnemo runs directly as a Chrome extension.

For development:
1. Make your changes to the source files
2. Reload the extension in `chrome://extensions/`
3. Test your changes in the side panel

## License

MIT License - see [LICENSE](LICENSE) file for details

## Support

For issues, questions, or feature requests, please open an issue on GitHub.

---

**Mnemo** - Never lose a tab again, but keep your browser clean.
